#include "QdpShmTraderApi.h"
#include <iostream>
#include <cstdlib>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <thread>
#include <chrono>

using namespace std;

#ifdef WIN32
#define WINDOWS
#endif

#ifdef WINDOWS
#include <windows.h>
typedef HANDLE THREAD_HANDLE;
#define SLEEP(ms) Sleep(ms)
#else
#include <pthread.h>
#include <sys/time.h>
#include <unistd.h>
typedef pthread_t THREAD_HANDLE;
#define SLEEP(ms) usleep((ms) * 1000)
typedef unsigned int DWORD;
#endif

// 报单录入操作是否完成的标志
// 经纪公司代码
TQdpFtdcBrokerIDType g_chBrokerID;
// 交易用户代码
TQdpFtdcUserIDType g_chUserID;
// 用户密码
TQdpFtdcPasswordType g_chPassword;
// 投资者代码
TQdpFtdcInvestorIDType g_chInvestorID;
// 用户本地最大报单号
int g_nOrdLocalID = 0;
/* 认证相关信息 */
// 是否需要认证 0-不需要 1-需要
int g_nAuthenticate = 0;
TQdpFtdcAppIDType g_chAppID;
TQdpFtdcPasswordType g_chAuthCode;
/// 交易API
CQdpShmTraderApi *g_pShmTraderApi = NULL;

class CThread
{
public:
    CThread()
    {
        m_hThread = (THREAD_HANDLE)0;
        m_IDThread = 0;
    }

    virtual ~CThread() {}

    virtual bool Create()
    {
        if (m_hThread != (THREAD_HANDLE)0)
        {
            return true;
        }
        bool ret = true;
#ifdef WIN32
        m_hThread = ::CreateThread(NULL, 0, _ThreadEntry, this, 0, &m_IDThread);
        if (m_hThread == NULL)
        {
            ret = false;
        }
#else
        ret = (::pthread_create(&m_hThread, NULL, &_ThreadEntry, this) == 0);
#endif
        return ret;
    }

    void ExitThread()
    {
#ifdef WIN32
        ::ExitThread(0);
#endif
    }

private:
#ifdef WIN32
    static DWORD WINAPI _ThreadEntry(LPVOID pParam)
#else
    static void *_ThreadEntry(void *pParam)
#endif
    {
        CThread *pThread = (CThread *)pParam;
        if (pThread->InitInstance())
        {
            pThread->Run();
        }

        pThread->ExitInstance();

        return NULL;
    }

    virtual bool InitInstance()
    {
        return true;
    }

    virtual void ExitInstance() {}

    virtual void Run() = 0;

private:
    THREAD_HANDLE m_hThread;
    DWORD m_IDThread;
};

class CMyWorkThread : public CThread
{
public:
    CMyWorkThread(CQdpShmTraderApi *pSuperApi) : m_pSuperApi(pSuperApi) {};
    ~CMyWorkThread() {};
    virtual void Run()
    {
        while (1)
        {
            m_pSuperApi->ReadFromSession();
            //		SLEEP(100);
        }
    }

public:
    CQdpShmTraderApi *m_pSuperApi;
};

void ReqLogin(int RequestID);

void ReqAuth(int RequestID);

void ReqQuoteAction(int RequestID);

void ReqQuoteInsert(int RequestID);

int ReqOrderAction(int RequestID);

int ReqOrderInsert(int RequestID);

class CShmTraderSpi : public CQdpShmTraderSpi
{
public:
    explicit CShmTraderSpi(CQdpShmTraderApi *pUserApi) :
    m_pTraderApi(pUserApi),
    m_bConnected(false),
    m_bIsLogin(false) {}

    ~CShmTraderSpi() {}

    // 实现CTraderSpi的各个接口
    void OnFrontConnected()
    {
        std::cout << "OnFrontConnected\n";
        // udp登出一次，防止会话未删除
        CQdpFtdcReqUserLogoutField pRspUserLogout;
        memset(&pRspUserLogout, 0, sizeof(pRspUserLogout));
        m_pTraderApi->ReqUserLogout(&pRspUserLogout, 0);
        // 必须睡眠，不能立刻登录
        sleep(1);

        m_bConnected = true;
    }

    void OnFrontDisconnected()
    {
        std::cout << "OnFrontDisconnected\n";
        m_bConnected = false;
        m_bIsLogin = false;
    }

    void OnRspUserLogin(CQdpFtdcRspUserLoginField *pRspUserLogin, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        if (pRspInfo == NULL)
        {
            std::cout << "OnRspUserLogin=NULL!\n";
            return;
        }

        if (pRspInfo->ErrorID != 0)
        {
            std::cout << "UserID: " << g_chUserID << "Login failed, ErrorMsg: " << pRspInfo->ErrorMsg;
            return;
        }
        std::cout << "UserID: " << g_chUserID << "Login Success.\n";

        m_bIsLogin = true;
    }

    void OnRspAuthenticate(CQdpFtdcRtnAuthenticateField *pRtnAuthenticate, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        if (pRspInfo == NULL)
        {
            std::cout << "OnRspAuthenticate=NULL!\n";
            return;
        }
        if (pRspInfo->ErrorID != 0)
        {
            std::cout << "OnRspAuthenticate failed, ErrorMsg:" << pRspInfo->ErrorMsg << "\n";
            return;
        }

        std::cout << "OnRspAuthenticate success, UserID:" << pRtnAuthenticate->UserID << "\n";

        // 认证成功后登录
        ReqLogin(nRequestID);
    }

    void OnRspOrderAction(CQdpFtdcOrderActionField *pOrderAction, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        if (pRspInfo == NULL)
        {
            std::cout << "OnRspOrderAction=NULL!\n";
            return;
        }
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "OnRspOrderAction failed, ErrorMsg:" << pRspInfo->ErrorMsg << "\n";
            return;
        }
        std::cout << "OnRspOrderAction success, OrderSysID=" << pOrderAction->OrderSysID;
    };

    void OnRspOrderInsert(CQdpFtdcInputOrderField *pRspInputOrder, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspOrderInsert\n";
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg
                      << ", RequestID: " << nRequestID << std::endl;
            return;
        }

        if (pRspInputOrder != NULL)
        {
            std::cout << "Success; InvestorID=[" << pRspInputOrder->InvestorID
                      << "],InstrumentID=[" << pRspInputOrder->InstrumentID
                      << "],OrderSysID=[" << pRspInputOrder->OrderSysID
                      << "],Volume=[" << pRspInputOrder->Volume
                      << "],LimitPrice=[" << pRspInputOrder->LimitPrice
                      << "],UserOrderLocalID=[" << pRspInputOrder->UserOrderLocalID
                      << "];\n";
        }
    }

    // traderSPI
    void OnRtnTrade(CQdpFtdcTradeField *pTrade)
    {
        std::cout << "OnRtnTrade: OrderSysID=" << pTrade->OrderSysID
                  << ", InstrumentID=" << pTrade->InstrumentID
                  << ", TradeID=" << pTrade->TradeID
                  << ", TradeVolume=" << pTrade->TradeVolume
                  << "\n";
    }

    void OnRtnOrder(CQdpFtdcOrderField *pOrder)
    {
        // store OrderSysID
        std::cout << "OnRtnOrder: OrderSysID=" << pOrder->OrderSysID
                  << ", InstrumentID=" << pOrder->InstrumentID
                  << ", Volume=" << pOrder->Volume
                  << ", OrderStatus=" << pOrder->OrderStatus
                  << "\n";
    }

    void OnRspQuoteInsert(CQdpFtdcInputQuoteField *pRspInputQuote, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) 
    {
        std::cout << "OnRspQuoteInsert\n";
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                        << ", ErrorMsg: " << pRspInfo->ErrorMsg << ", RequestID: " << nRequestID << "\n";
            return;
        }

        if (pRspInputQuote != NULL)
        {
            std::cout << "Success,InstrumentID=[" << pRspInputQuote->InstrumentID
                      << "],AskPrice=[" <<  pRspInputQuote->AskPrice
                      << "],AskVolume=[" << pRspInputQuote->AskVolume
                      << "],BidPrice=[" << pRspInputQuote->BidPrice
                      << "],BidVolume=[" << pRspInputQuote->BidVolume << "\n";
        }
    }

    void OnRspQuoteAction(CQdpFtdcQuoteActionField *pQuoteAction, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
    {
        std::cout << "OnRspQuoteAction\n";
        if (pRspInfo != NULL && pRspInfo->ErrorID != 0)
        {
            std::cout << "failed; ErrorID: " << pRspInfo->ErrorID
                      << ", ErrorMsg: " << pRspInfo->ErrorMsg
                      << ", RequestID: " << nRequestID << std::endl;
            return;
        }
        if (pQuoteAction != NULL)
        {

            std::cout << "Success; UserOrderLocalID=[" << pQuoteAction->UserOrderLocalID
                      << "], UserOrderActionLocalID=[" << pQuoteAction->UserOrderActionLocalID
                      << "], OrderSysID=[" << pQuoteAction->OrderSysID
                      << "];\n";
        }
    }

    void OnRtnQuote(CQdpFtdcQuoteField *pQuote)
    {
        // 报价回报
        std::cout << "OnRtnQuote, OrderSysID=" << pQuote->OrderSysID
                  << ", InvestorID=" << pQuote->InvestorID
                  << ", UserOrderLocalID=" << pQuote->UserOrderLocalID
                  << ", OrderStatus=" << pQuote->OrderStatus
                  << ", BidOrderSysID=" << pQuote->BidOrderSysID
                  << ", AskOrderSysID=" << pQuote->AskOrderSysID
                  << "\n";
    }

private:
    CQdpShmTraderApi *m_pTraderApi; // spi对应的shm api

public:
    bool m_bIsLogin;
    bool m_bConnected;
};

void ReqLogin(int RequestID)
{
    CQdpFtdcReqUserLoginField reqUserLogin;

    strcpy(reqUserLogin.UserProductInfo, "demo_test");
    strcpy(reqUserLogin.BrokerID, g_chBrokerID);
    strcpy(reqUserLogin.UserID, g_chUserID);
    strcpy(reqUserLogin.Password, g_chPassword);
    // 发出登陆请求
    g_pShmTraderApi->ReqUserLogin(&reqUserLogin, RequestID);
}

void ReqAuth(int RequestID)
{
    CQdpFtdcAuthenticateField reqfield;
    strcpy(reqfield.BrokerID, g_chBrokerID);
    strcpy(reqfield.UserID, g_chUserID);
    strcpy(reqfield.UserProductInfo, "demo_test");
    strcpy(reqfield.AppID, g_chAppID);
    strcpy(reqfield.AuthCode, g_chAuthCode);
    // 发出认证请求
    g_pShmTraderApi->ReqAuthenticate(&reqfield, RequestID);
}

void ReqQuoteAction(int RequestID)
{
    std::cout << "ReqQuoteAction Info:" << std::endl;
    CQdpFtdcQuoteActionField quote;
    memset(&quote, 0, sizeof(quote));
    std::cout << "ExchangeID:";
    std::cin >> quote.ExchangeID;
    quote.UserOrderActionLocalID = ++g_nOrdLocalID;
    std::cout << "OrderSysID:";
    std::cin >> quote.OrderSysID;
    std::cout << "UserOrderLocalID:";
    std::cin >> quote.UserOrderLocalID;
    quote.ActionFlag = QDP_FTDC_AF_Delete;
    g_pShmTraderApi->ReqQuoteAction(&quote, RequestID);
}

void ReqQuoteInsert(int RequestID)
{
    std::cout << "ReqQuoteInsert Info:" << std::endl;
    CQdpFtdcInputQuoteField quote;
    memset(&quote, 0, sizeof(quote));

    // 投资者编号 (对于API7.0版本,InstrumentIDNum通过合约查询的回调获取)
    strcpy(quote.BrokerID,g_chBrokerID);
    strcpy(quote.InvestorID,g_chInvestorID);
    strcpy(quote.UserID,g_chUserID);
    // 交易所编号
    std::cout << "ExchangeID: ";
    std::cin >> quote.ExchangeID;
    // 合约号
    std::cout << "InstrumentID: ";
    std::cin >> quote.InstrumentID;
    // 本地报单号
    quote.UserOrderLocalID = ++g_nOrdLocalID;

    // 卖出参数
    std::cout << "AskOffsetFlag: ";
    std::cin >> quote.AskOffsetFlag;
    std::cout << "AskHedgeFlag: ";
    std::cin >> quote.AskHedgeFlag;
    std::cout << "AskPrice: ";
    std::cin >> quote.AskPrice;
    std::cout << "AskVolume: ";
    std::cin >> quote.AskVolume;
    quote.AskOrderRef = ++g_nOrdLocalID;

    // 买入参数
    std::cout << "BidOffsetFlag: ";
    std::cin >> quote.BidOffsetFlag;
    std::cout << "BidHedgeFlag: ";
    std::cin >> quote.BidHedgeFlag;
    std::cout << "BidPrice: ";
    std::cin >> quote.BidPrice;
    std::cout << "BidVolume: ";
    std::cin >> quote.BidVolume;
    quote.BidOrderRef = ++g_nOrdLocalID;

    g_pShmTraderApi->ReqQuoteInsert(&quote, RequestID);
}

int ReqOrderAction(int RequestID)
{
    std::cout << "ReqOrderAction Info:" << std::endl;
    CQdpFtdcOrderActionField ord;
    memset(&ord, 0, sizeof(ord));
    // 交易所
    std::cout << "ExchangeID: ";
    std::cin >> ord.ExchangeID;
    // 被撤订单的本地报单编号
    std::cout << "UserOrderLocalID: ";
    std::cin >> ord.UserOrderLocalID;
    // 本次撤单操作的本地编号
    ord.UserOrderActionLocalID = ++g_nOrdLocalID;
    // 报单编号
    std::cout << "OrderSysID: ";
    std::cin >> ord.OrderSysID;
    // 报单操作标志
    ord.ActionFlag = QDP_FTDC_AF_Delete;

    return g_pShmTraderApi->ReqOrderAction(&ord, RequestID);
}

int ReqOrderInsert(int RequestID)
{
    std::cout << "ReqOrderInsert Info:" << std::endl;
    CQdpFtdcInputOrderField ord;
    memset(&ord, 0, sizeof(ord));
    // 投资者ID
    strcpy(ord.BrokerID,g_chBrokerID);
    strcpy(ord.InvestorID,g_chInvestorID);
    strcpy(ord.UserID,g_chUserID);
    // 交易所编号
    std::cout << "ExchangeID: ";
    std::cin >> ord.ExchangeID;
    // 合约号
    std::cout << "InstrumentID: ";
    std::cin >> ord.InstrumentID;
    // 本地报单号
    ord.UserOrderLocalID = ++g_nOrdLocalID;
    // 报单类型
    std::cout << "OrderPriceType: ";
    std::cin >> ord.OrderPriceType;
    // ord.OrderPriceType = QDP_FTDC_OPT_LimitPrice;
    // 买卖方向
    std::cout << "Direction: ";
    std::cin >> ord.Direction;
    // ord.Direction = QDP_FTDC_D_Buy;
    // 开平标志
    std::cout << "OffsetFlag: ";
    std::cin >> ord.OffsetFlag;
    // strcpy(&(ord.OffsetFlag), "0");
    // 投机套保标志
    std::cout << "HedgeFlag: ";
    std::cin >> ord.HedgeFlag;
    // strcpy(&(ord.HedgeFlag), "1");
    // 价格
    std::cout << "LimitPrice: ";
    std::cin >> ord.LimitPrice;
    // ord.LimitPrice = 3074;
    // 数量
    std::cout << "Volume: ";
    std::cin >> ord.Volume;
    // ord.Volume = 1;
    // 有效期类型
    std::cout << "TimeCondition: ";
    std::cin >> ord.TimeCondition;
    // ord.TimeCondition = QDP_FTDC_TC_GFD;
    // 成交量类型
    std::cout << "VolumeCondition: ";
    std::cin >> ord.VolumeCondition;
    // ord.VolumeCondition = QDP_FTDC_VC_AV;

    return g_pShmTraderApi->ReqOrderInsert(&ord, RequestID);
}

void ShowHelp()
{
    std::cout << "输入数字执行对应的操作:\n"
                 " 1: 报单录入请求\n"
                 " 2: 报单操作请求\n"
                 " 3: 报价录入请求\n"
                 " 4: 报价操作请求\n"
                 "------------------------------\n";
}

void OrderFunc(CShmTraderSpi *pShmTraderSpi)
{
    if (NULL == pShmTraderSpi)
    {
        return;
    }
    while (!pShmTraderSpi->m_bConnected)
    {
        std::this_thread::sleep_for(std::chrono::microseconds(1000));
        continue;
    }
    int RequestID = 0;

    std::cout << "please input user info...\n";
    std::cout << "BrokerID:";
    std::cin >> g_chBrokerID;
    std::cout << "UserID:";
    std::cin >> g_chUserID;
    std::cout << "Password:";
    std::cin >> g_chPassword;
    std::cout << "InvestorID:";
    std::cin >> g_chInvestorID;
    // 输入是否认证 0-否 1-是
    std::cout << "Is Need Authenticate (0-no, 1-yes):";
    std::cin >> g_nAuthenticate;
    if (g_nAuthenticate == 1)
    {
        std::cout << "AppID:";
        std::cin >> g_chAppID;
        std::cout << "AuthCode:";
        std::cin >> g_chAuthCode;
        ReqAuth(++RequestID);
    }
    else
    {
        ReqLogin(++RequestID);
    }

    while (!pShmTraderSpi->m_bIsLogin)
    {
        std::this_thread::sleep_for(std::chrono::microseconds(1000));
        continue;
    }

    // 操作类型
    int operationType = 0;
    while (1)
    {
        ShowHelp();
        // 接受用户输入 执行对应的查询和报单操作
        std::cin >> operationType;
        switch (operationType)
        {
        case 1:
            // 报单录入请求
            ReqOrderInsert(RequestID);
            break;
        case 2:
            // 报单操作请求
            ReqOrderAction(RequestID);
            break;
        case 3:
            // 报价录入请求
            ReqQuoteInsert(RequestID);
            break;
        case 4:
            // 报价操作请求
            ReqQuoteAction(RequestID);
            break;
        default:
            break;
        }
        RequestID++;
    }
}

// TODO:添加报单，登录和认证功能
int main()
{
    // 产生一个CQdpShmTraderApi实例
    CQdpShmTraderApi *pSupUserApi = CQdpShmTraderApi::CreateShmTraderApi();

    // 保存api
    g_pShmTraderApi = pSupUserApi;

    // 产生一个事件处理的实例
    CShmTraderSpi *pShmTraderSpi = new CShmTraderSpi(pSupUserApi);

    // 注册事件处理的实例
    pSupUserApi->RegisterSpi(pShmTraderSpi);

    // 设置量投科技服务的地址，可以注册多个地址备用

    //pSupUserApi->RegisterFront("udp://192.168.92.212:6099"); // UDP模式
    pSupUserApi->RegisterFront("shm://65432:20");//SHM模式
    pSupUserApi->Connect();

    CMyWorkThread myCMyWorkThread(pSupUserApi);
	myCMyWorkThread.Create();

    OrderFunc(pShmTraderSpi);

    while (1)
    {
        sleep(1);
    }
    return 0;
}