/////////////////////////////////////////////////////////////////////////
///@system QuantDo Platform
///@company ϺͶƼ޹˾
///@file QdpShmTraderApi.h
///@brief ˿ͻ˽ӿ
///@history
/////////////////////////////////////////////////////////////////////////

#if !defined(QDP_SHMTRADERAPI_H)
#define QDP_SHMTRADERAPI_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "QdpFtdcUserApiStruct.h"

#if defined(ISLIB) && defined(WIN32)
#ifdef LIB_TRADER_API_EXPORT
#define TRADER_API_EXPORT __declspec(dllexport)
#else
#define TRADER_API_EXPORT __declspec(dllimport)
#endif
#else
#define TRADER_API_EXPORT 
#endif

class CQdpShmTraderSpi
{
public:
	///ͻ뽻׺̨ͨʱδ¼ǰ÷á
	virtual void OnFrontConnected(){};
	
	///ͻ뽻׺̨ͨӶϿʱ÷
	virtual void OnFrontDisconnected(){};

	///Ӧ
	virtual void OnRspError(CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///û¼Ӧ
	virtual void OnRspUserLogin(CQdpFtdcRspUserLoginField *pRspUserLogin, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///¼Ӧ
	virtual void OnRspOrderInsert(CQdpFtdcInputOrderField *pInputOrder, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ӧ
	virtual void OnRspOrderAction(CQdpFtdcOrderActionField *pOrderAction, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ɽر
	virtual void OnRtnTrade(CQdpFtdcTradeField *pTrade) {};

	///ر
	virtual void OnRtnOrder(CQdpFtdcOrderField *pOrder) {};

	///¼֤Ӧ
	virtual void OnRspAuthenticate(CQdpFtdcRtnAuthenticateField *pRtnAuthenticate, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯ¼Ӧ
	virtual void OnRspForQuoteInsert(CQdpFtdcInputForQuoteField *pInputForQuote, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	///¼Ӧ
	virtual void OnRspQuoteInsert(CQdpFtdcInputQuoteField *pInputQuote, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
	
	///۲Ӧ
	virtual void OnRspQuoteAction(CQdpFtdcQuoteActionField *pQuoteAction, CQdpFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ۻر
	virtual void OnRtnQuote(CQdpFtdcQuoteField *pQuote) {};

	///UDPͨѶʱյack
	virtual void OnRtnAck(int nRequestID) {};
};

class TRADER_API_EXPORT CQdpShmTraderApi
{
public:
	///TraderApi
	///@param 
	///@return UserApi
	static CQdpShmTraderApi *CreateShmTraderApi();	
	
	///עǰûַ
	///@param pszFrontAddressǰûַ
	///@remark ַĸʽΪprotocol://ipaddress:port磺shm://12345:20 
	///@remark shmڴ棬12345ڴʶá20
	///@remark efvi://localip@remotip@:port ,ex: efvi://192.168.92.212@192.168.100.175:6688
	virtual void RegisterFront(char *pszFrontAddress) = 0;
	
	///עصӿ
	///@param pSpi Իصӿʵ
	virtual void RegisterSpi(CQdpShmTraderSpi *pSpi) = 0;

	///ڴ淽ʽӷ
	virtual bool Connect() = 0;

	///ͨȡ
	virtual int ReadFromSession() = 0;
	
	///û¼
	virtual int ReqUserLogin(CQdpFtdcReqUserLoginField *pReqUserLogin, int nRequestID) = 0;

	///û˳
	virtual int ReqUserLogout(CQdpFtdcReqUserLogoutField *pReqUserLogout, int nRequestID) = 0;

	///¼
	virtual int ReqOrderInsert(CQdpFtdcInputOrderField *pInputOrder, int nRequestID) = 0;

	///Udp¼   ṹСһЩҲ
	virtual int UdpReqOrderInsert(CQdpFtdcUdpInputOrderField *pInputOrder, int nRequestID) = 0;

	///
	virtual int ReqOrderAction(CQdpFtdcOrderActionField *pOrderAction, int nRequestID) = 0;

	///¼֤
	virtual int ReqAuthenticate(CQdpFtdcAuthenticateField *pAuthenticate, int nRequestID) = 0;

	///زʱʹõʷ鱨
	virtual int ReqMarketData(CQdpFtdcClientDepthMarketDataField *pClientDepthMarketData, int nRequestID) = 0;

	///ѯ¼
	virtual int ReqForQuoteInsert(CQdpFtdcInputForQuoteField *pInputForQuote, int nRequestID) = 0;
	
	///¼
	virtual int ReqQuoteInsert(CQdpFtdcInputQuoteField *pInputQuote, int nRequestID) = 0;
	
	///۲
	virtual int ReqQuoteAction(CQdpFtdcQuoteActionField *pQuoteAction, int nRequestID) = 0;
protected:
	~CQdpShmTraderApi(){};
};

#endif
